/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2001          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */

static char *sccsid = "@(#)50   1.3   src/rsct/pgs/samples/Sample_ProviderTable.C, gssamples, rsct_rori, roris01a 5/14/01 09:43:29";


#if !defined(_HAGSD_COPYRIGHT_H)
#define _HAGSD_COPYRIGHT_H
static char copyright[] = "Licensed Materials - Property of IBM\n\
(C) COPYRIGHT International Business Machines Corp. 1998,2001.\n\
All Rights Reserved.\n\
US Government Users Restricted Rights - Use, duplication or \n\
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
#endif

/*********************************************************************/
/*
 * Name:  Sample_ProviderTable.C
 *
 * Build the sorted list of providers in the system, sorted by node
 * number.
 *
 * See Sample_Subscribe.C for more info.
 */
 /*********************************************************************/

#include "Sample_ProviderTable.h"       // Standard includes.
#include "Sample_Node.h"                // Define the Node objects.

ProviderTable::ProviderTable(void)
{
    haveAlias = haveDeath = 0;
    count = 0;
    highestNode = -1;

    for (int i = 0; i < MAX_NODE_NUMBER; i++) {
        providerTable[i] = NULL;
    }

    return;
}

ProviderTable::~ProviderTable(void)
{
    if (-1 == highestNode) return;      // No Nodes allocated.

    for (int i = 0; i <= highestNode; i++) {
        delete providerTable[i];
    }

    return;
}

/*********************************************************************/
/*
 * Add a provider into the correct frame.  Return number of providers
 * in table.
 */
/*********************************************************************/

int     ProviderTable::Add(short _instance,
                           short _node,
                           unsigned int *_IPaddr,
                           ha_gs_adapter_death_t *_death)
{
    haveAlias = (NULL != _IPaddr);
    haveDeath = (NULL != _death);

    if (NULL == providerTable[_node]) {
        providerTable[_node] = new Node(_node, _instance, _IPaddr, _death);
    } else {
        providerTable[_node]->Add(_instance, _IPaddr, _death);
    }

    if (_node > highestNode) highestNode = _node;

    return(++count);
}
        
/*********************************************************************/
/*
 * Print out table.  Use the "simple" print function, dump out the
 * list in node number order, packing providers to each line, limit
 * each line to 80 characters.
 */
/*********************************************************************/

void    ProviderTable::Print(void)
{
    if (-1 == highestNode) return;      // No Nodes allocated.

    int _printed = 0;

    // First time through is to print out providers.  Then do likewise
    // for the special data.

    for (int i = 0; i <= highestNode; i++) {
        if (NULL != providerTable[i]) {
            _printed = providerTable[i]->PrintSimple(_printed);
        }
    }
    cout << endl;
    if (haveAlias) {
        _printed = 0;
        cout << "Adapter alias array: " << endl;
        for (int i = 0; i <= highestNode; i++) {
            if (NULL != providerTable[i]) {
                _printed = providerTable[i]->PrintSpecialIP(_printed);
            }
        }
        cout << endl;
    }
    if (haveDeath) {
        _printed = 0;
        cout << "Adapter death array: " << endl;
        for (int i = 0; i <= highestNode; i++) {
            if (NULL != providerTable[i]) {
                _printed = providerTable[i]->PrintSpecialDeath(_printed);
            }
        }
        cout << endl;
    }
    return;
}
